//****************************************************************************************
// Name:		params.cpp
// Platform:	SQL Server 2000 SP3a or higher, Windows NT, 2000 or XP
// Author:		Copyright (c) 2006 by Michael Coles, MCDBA
//
// Description:	This is a class that provides extended stored procedure parameter access.
//
// LEGAL STUFF:
// ------------
// Copyright (C) 2005 - 2006 by Michael Coles, MCDBA
//
// Some included code included is released under the redistribution agreements as 
// specified by the authors of the respective code.  Copyright holders of this included 
// code maintain all copyright and other rights to their original or derivative works.
//
// All rights reserved.                          
//
// REDISTRIBUTION OF THIS CODE:
// ----------------------------
// All code included in this package is either the original work of the copyright holder,
// or derivative work based on other copyright holders' works.  All derivative works 
// include information as required by the copright holders' redistribution agreements.
// These redistribution agreements, where possible, are included in the text of the source
// code distributed with this code.
//
// Redistribution and use in source and binary forms, with or without modification, are 
// permitted provided that the following conditions are met:
//
//   1. Redistributions of source code must retain the above copyright notice, this list 
//      of conditions and the following disclaimer.
//
//   2. Redistributions in binary form must reproduce the above copyright notice, this 
//      list of conditions and the following disclaimer in the documentation and/or other 
//      materials provided with the distribution.
//
//   3. The names of its contributors may not be used to endorse or promote products 
//      derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR 
// BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY 
// WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//****************************************************************************************

#include <params.h>
// getparamcount()
//
// This little routine retrieves the total number of parameters passed in to us.
// Always call this before calling getparam, to ensure that we are not trying to
// retrieve more parameters than were passsed in.
//
// Parameters:
//		SRV_PROC *srvproc	Server process pointer
// Returns:
//		int					Number of parameters passed in to from SQL Server
//
//void params::initialize(SRV_PROC *srvproc_in) {
//	params::srvproc = srvproc_in;
//}

int params::getparamcount(SRV_PROC *srvproc) {
	return (srv_rpcparams(srvproc));
}
// getparam()
//
// This handy little routine retrieves the specified parameter.  For some reason, 
// SQL numbers parameters beginning with 1, not C-standard 0 as we might expect.
//
// Parameters:
//		SRV_PROC *srvproc	Server process pointer
//		int paramnum		Number of the SQL Server parameter to retrieve
//		params *p			Pointer to a params object
//
void params::getparam(SRV_PROC *srvproc, int paramnum, params *p) {
	// Set the success/failure code
	SRVRETCODE rc = SUCCEED;
	// Get the parameter length first
	rc = srv_paraminfo(srvproc, paramnum, &p->type, &p->maxlength, &p->length, NULL, &p->isnull);
	if (rc == SUCCEED) 
	{
		// Now we reserve the required space, +1 extra byte for a '\0' string end marker.
		p->cdata = new BYTE[p->length + 1];
		memset(p->cdata, 0, p->length + 1);
		// Now we retrieve the actual parameter value.
		rc = srv_paraminfo(srvproc, paramnum, &p->type, &p->maxlength, &p->length, p->cdata, &p->isnull);
		p->isoutput = (srv_paramstatus(srvproc, paramnum) & SRV_PARAMRETURN);
	}
	p->success = rc;
}
// ~params()
//
// This destructor will release the cdata array of dynamically allocated memory.
//
params::~params() {
	// Only if it was assigned.
	if (this->cdata != NULL) {
		delete [] this->cdata;
	}
	this->cdata = NULL;
};